<?php
declare(strict_types=1);

namespace AL\PhpWndb\Model\Synsets\Nouns;

use AL\PhpEnum\Enum;

/**
 * @method static $this TOPS()              unique beginner for nouns
 * @method static $this ACT()               nouns denoting acts or actions
 * @method static $this ANIMAL()            nouns denoting animals
 * @method static $this ARTIFACT()          nouns denoting man-made objects
 * @method static $this ATTRIBUTE()         nouns denoting attributes of people and objects
 * @method static $this BODY()              nouns denoting body parts
 * @method static $this COGNITION()         nouns denoting cognitive processes and contents
 * @method static $this COMMUNICATION()     nouns denoting communicative processes and contents
 * @method static $this EVENT()             nouns denoting natural events
 * @method static $this FEELING()           nouns denoting feelings and emotions
 * @method static $this FOOD()              nouns denoting foods and drinks
 * @method static $this GROUP()             nouns denoting groupings of people or objects
 * @method static $this LOCATION()          nouns denoting spatial position
 * @method static $this MOTIVE()            nouns denoting goals
 * @method static $this OBJECT()            nouns denoting natural objects (not man-made)
 * @method static $this PERSON()            nouns denoting people
 * @method static $this PHENOMENON()        nouns denoting natural phenomena
 * @method static $this PLANT()             nouns denoting plants
 * @method static $this POSSESSION()        nouns denoting possession and transfer of possession
 * @method static $this PROCESS()           nouns denoting natural processes
 * @method static $this QUANTITY()          nouns denoting quantities and units of measure
 * @method static $this RELATION()          nouns denoting relations between people or things or ideas
 * @method static $this SHAPE()             nouns denoting two and three dimensional shapes
 * @method static $this STATE()             nouns denoting stable states of affairs
 * @method static $this SUBSTANCE()         nouns denoting substances
 * @method static $this TIME()              nouns denoting time and temporal relations
 */
class SynsetNounsCategoryEnum extends Enum {}
