<?php declare(strict_types=1);

namespace Nadybot\User\Modules\OWEATHER_MODULE\Model;

use EventSauce\ObjectHydrator\PropertyCasters\CastListToType;

class ForecastWeather {
	/**
	 * @param ShortWeather[]           $weather
	 * @param array<string,int>        $clouds
	 * @param null|array<string,float> $rain    Rain volume for the last 3 hours, mm
	 *
	 * @psalm-param list<ShortWeather> $weather
	 */
	public function __construct(
		public int $dt,
		public TempData $main,
		#[CastListToType(ShortWeather::class)] public array $weather,
		public array $clouds,
		public Wind $wind,
		public ?int $visibility,
		public float $pop,
		public ?array $rain=null,
	) {
	}
}
