<?php declare(strict_types=1);

namespace Nadybot\User\Modules\OWEATHER_MODULE\Model;

class Weather {
	/**
	 * @param ShortWeather[]    $weather
	 * @param array<string,int> $clouds
	 *
	 * @psalm-param list<ShortWeather>    $weather
	 */
	public function __construct(
		public Coordinates $coord,
		#[CastListTypType(ShortWeather::class)] public array $weather,
		public string $base,
		public TempData $main,
		public ?int $visibility,
		public Wind $wind,
		public array $clouds,
		public int $dt,
		public Sys $sys,
		public int $timezone,
		public int $id,
		public string $name,
		public int $cod,
	) {
	}
}
