<?php declare(strict_types=1);

namespace Nadybot\User\Modules\WIKI_MODULE;

use EventSauce\ObjectHydrator\PropertyCasters\CastListToType;

class WikiPage {
	/**
	 * @param WikiLink[] $links
	 *
	 * @psalm-param list<WikiLink> $links
	 */
	public function __construct(
		public int $pageid,
		public int $ns,
		public string $title,
		public ?string $extract=null,
		#[CastListToType(WikiLink::class)] public array $links=[],
	) {
	}
}
